<?php
function getFullStats()
{
  if(!$this->dbo) return "Statystki nie s dostpne.";

  //Weryfikacja danych
  $ile = -1;
  if(isset($_GET['ile'])){
    $ile = intval($_GET['ile']);
    if($ile >= -1){
      if($ile == 0){
        //Czy zostay przekazane daty?
        if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
          //Czy daty odpowiadaj formatowi?
          if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
             !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
            //Niezgodno formatu.
            $ile = -1;
          }
          else{
            //Odczytanie dat.
            $dataOd = $_GET['dataOd'];
            $dataDo = $_GET['dataDo'];
          }
        }
        //Brak dat przy zaznaczonej opcji zakresu.
        else{
          $ile = -1;
        }
      }
      else{
        //Ustalenie maksymalnej dopuszczalnej liczby dni.
        if($ile > 3660) $ile = 3660;
      }
    }
    //Parametr ile by nieprawidowy.
    else{
      $ile = -1;
    }
  }
  
  //Formowanie warunkw zapyta i nagwka tabeli.
  if($ile == 0){
    //Dodanie warunku dotyczcego dat.
    $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
    $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
  }
  else if($ile > 0){
    //Dodanie warunku dotyczcego wybranego okresu.
    $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
    $statsInfo = "Statystyki z ostatnich $ile dni.";
  }
  else{
    //Dodanie pustego warunku.
    $cond = ' WHERE 1=1 ';
    $statsInfo = "Pene statystyki";
  }

  //Pobieranie liczby odwiedzin.
  $query = "SELECT COUNT(*) AS Ile FROM Stats ";
  $allVisits = $this->getQuerySingleResult($query . $cond);
  $regVisits = $this->getQuerySingleResult($query . $cond . 
               'AND UserId <> 0 ');
  $allVisits = (int) $allVisits;
  $regVisits = (int) $regVisits;
  $guestVisits = $allVisits - $regVisits;
  
  //Pobieranie statystyk przegldarek.
  $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Przegladarki ";
  $query .= $cond;
  $query .= " AND Stats.BrowserId = Przegladarki.Id ";
  $query .= "GROUP BY BrowserId ORDER BY Ile DESC";
  
  $browsersInfo = $this->getQueryResultAsTableRows($query);

  //Pobieranie statystyk systemw.
  $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Systemy ";
  $query .= $cond;
  $query .= " AND Stats.SystemId = Systemy.Id ";
  $query .= "GROUP BY SystemId ORDER BY Ile DESC";

  $systemsInfo = $this->getQueryResultAsTableRows($query);
  
  //Najczciej logujcy si uytkownicy.
  $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Users ";
  $query .= $cond;
  $query .= " AND Stats.UserId = Users.Id AND Users.Id <> 0 ";
  $query .= "GROUP BY UserId ORDER BY Ile DESC LIMIT 10";

  $activeUsers = $this->getQueryResultAsTableRows($query);
  
  //Najczciej wystpujce adresy IP.
  $query = "SELECT inet_ntoa(IP) AS IP, COUNT(*) AS Ile FROM Stats ";
  $query .= $cond;
  $query .= "GROUP BY IP ORDER BY Ile DESC LIMIT 10";
  
  $ips = $this->getQueryResultAsTableRows($query);
  
  //Adresy IP i daty ostatnich 10 pocze.
  $query = "SELECT inet_ntoa(IP) AS IP, Data FROM Stats ";
  $query .= $cond;
  $query .= "ORDER BY Data DESC LIMIT 10";
  
  $lastips = $this->getQueryResultAsTableRows($query);
  
  include 'statTable.php';
  return $result;
}
?>